<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Carbon\Carbon;

use App\Models\Tournaments;

class CountryStateCityApiController extends Controller
{
     public function getAllTournaments()
    {
        $tournaments = Tournaments::all();
    
        if ($tournaments->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'No tournaments found.',
                'data' => []
            ], 404);
        }
    
        $formattedTournaments = $tournaments->map(function ($tournament) {
            $start = Carbon::createFromFormat('m/d/Y', $tournament->Startdate)->format('Y-m-d');
            $daysCount = count(array_filter(explode(',', str_replace(' ', '', $tournament->Days))));
            $end = Carbon::createFromFormat('Y-m-d', $start)->addDays($daysCount - 1)->format('Y-m-d');
            $tournament->Startdate = $start;
            $tournament->enddate = $end;
            return $tournament;
        });
    
        return response()->json([
            'success' => true,
            'message' => 'Tournaments retrieved successfully.',
            'data' => $formattedTournaments
        ]);
    }
}
