<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CountryStateCityApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('v1')->group(function () {
    Route::get('/tournaments', [CountryStateCityApiController::class, 'getAllTournaments']);
    Route::get('/hotel-search', [CountryStateCityApiController::class, 'hotelSearch']);
    Route::get('/search-flights', [CountryStateCityApiController::class, 'search_flights']);
    Route::get('/hotel-flight-search', [CountryStateCityApiController::class, 'hotelFlightSearch']);
});
